<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" media-type="text/html; charset=ISO-8859-1"/>
<xsl:param name="num" select="6"/>
<xsl:template match="/">
  <html>
    <head>
      <title>La logithque : <xsl:value-of select="/logitheque/categorie[$num]/@nom"/></title>
      <meta name="Robots" content="noindex, nofollow"/>
    </head>
    <body><a name="haut"></a>
      <table cellpadding="3" width="500"><tr><td height="450" valign="top">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
          <tr>
            <td align="center"><h2><xsl:value-of select="/logitheque/categorie[$num]/@nom"/></h2></td>
          </tr>
        </table><br/>
        <xsl:apply-templates select="/logitheque/categorie[position()=$num]"/>
      </td></tr></table>
    </body>
  </html>
</xsl:template>

<xsl:template match="/logitheque/categorie">
  <table border="0" cellpadding="0" cellspacing="1" width="100%" class="produit">
    <colgroup span="3"></colgroup>
    <colgroup align="right"></colgroup>
    <colgroup align="center"></colgroup>
    <tr><th colspan="5" style="font-size:14pt">Logiciel</th><td> </td></tr><tr>
      <th style="font:11pt bold; text-align:left" width="35%">Editeur</th>
      <th style="font:11pt bold" width="10%">Langue</th>
      <th style="font:11pt bold" width="24%">OS</th>
      <th style="font:11pt bold" width="25%">Prix</th>
      <th style="font:11pt bold" width= "6%">Panier</th></tr>
      <xsl:apply-templates>
        <xsl:sort select="nom"/>
      </xsl:apply-templates>
  </table>
  <br/>
</xsl:template>

<xsl:template name="cellule0" match="/logitheque/categorie/logiciel">
  <tr>
    <td colspan="5" bgcolor="#FFF4D0" class="somniv1" height="24">
      <xsl:choose>
        <xsl:when test="@code != '0'">
          <a href="
http://aff.blackorange.com/affilient/Tracking/clic.asp?p1=v%C86u&amp;p2=v%C8Q%3B&amp;p3=v2Nt&amp;p4=v%C8Q%3Bv%C86u&amp;partner=blackorange&amp;produit={@code}" target="_blank">
            <xsl:apply-templates select="nom"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <a href="{editeur/@lien}" target="_blank">
            <xsl:apply-templates select="nom"/>
          </a>
        </xsl:otherwise>
      </xsl:choose> - <xsl:apply-templates select="./commentaire"/>
    </td>
  </tr><tr>
    <td style="white-space:nowrap">
      <a href="{editeur/@lien}" target="_blank">
        <xsl:apply-templates select="./editeur"/>
      </a>
    </td><td>
      <xsl:apply-templates select="./langue"/>
    </td><td>
      <xsl:apply-templates select="./plateforme"/>
    </td><td>
      <xsl:apply-templates select="./prix"/>
        <xsl:text> </xsl:text>
      <xsl:apply-templates select="prix/@monnaie"/>
    </td><td>
      <xsl:if test="@code != '0'">
        <script src="http://195.154.208.217/media/dsveqxjs.asp?p1=a%40%C0%CD&amp;p2=a%40B%7D&amp;p3=aDXb&amp;produit={@code}&amp;target=_blank"/>
        </xsl:if>
    </td>
  </tr>
</xsl:template>
</xsl:stylesheet>
