<?php
  // Fichier : traitement.php
  function contenu_textuel($noeud_parent)
  {
    $noeuds = $noeud_parent->child_nodes();
    while($noeud = array_shift($noeuds))
    {
      if ($noeud->node_type() == XML_TEXT_NODE)
      {
        $resultat = $noeud->node_value();
        return $resultat;
      }
    }
  }

  function traitement_element($noeud_parent, $nom)
  {
    $noeuds = $noeud_parent->child_nodes();
    while($noeud = array_shift($noeuds))
    {
      if ($noeud->node_name() == $nom)
      {
        $resultat = contenu_textuel($noeud);
        return $resultat;
      }
    }
  }

  function traitement_attribut($noeud_parent, $nom, $attribut)
  {
    $noeuds = $noeud_parent->child_nodes();
    while($noeud = array_shift($noeuds))
    {
      if ($noeud->node_name() == $nom)
      {
        $resultat = $noeud->get_attribute($attribut);
        return $resultat;
      }
    }
  }

  $tab_elements = array("nom","commentaire","editeur","prix");
  $tab_attributs = array("langue"=>0,
                         "systeme_exploitation"=>0,
                         "adresse"=>2,
                         "monnaie"=>3);

  $xml_doc = domxml_open_file("c:\chemin\fichier.xml") 
    or die("Impossible d'ouvrir le fichier XML !");
  $element_racine = $xml_doc->document_element();
  $noeuds_enfants = $element_racine->child_nodes();

  foreach($noeuds_enfants as $noeud)
  {
    if($noeud->node_type() == XML_TEXT_NODE) continue;
    for($i = 0; $i < sizeof($tab_elements); $i++)
    {
      ${$tab_elements[$i]} = traitement_element($noeud, $tab_elements[$i]);
    }

    foreach($tab_attributs as $cle=>$valeur)
    {
      $$cle = traitement_attribut($noeud, $tab_elements[$valeur], $cle);
    }

    echo "<h4>Logiciel : " . $nom
         . "</h4>Langue : " . $langue
         . "<br>Systme d'exploitation : " . $systeme_exploitation
         . "<br>Commentaire : " . $commentaire
         . "<br>Editeur : " . $editeur
         . "<br>Adresse : " . $adresse
         . "<br>Prix : " . $prix . " " . $monnaie;
  }
?>