<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xhtml="http://www.w3.org/1999/xhtml">
  <xsl:output method="xml" version="1.0" encoding="ISO-8859-1" 
              omit-xml-declaration="no" 
              doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
              doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
  <xsl:template match="xhtml:html">
    <html>
      <xsl:apply-templates select="xhtml:body"/>
    </html>
  </xsl:template>
  <xsl:template match="xhtml:body">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="FR">
      <head>
        <title>
          <xsl:value-of select="xhtml:h3"/> - <xsl:value-of select="xhtml:h1"/>
        </title>
      </head>
      <body>
        <h1>
          <xsl:value-of select="xhtml:h1"/>
        </h1>
        <dd>
          <xsl:for-each select="xhtml:h2">
            <dl>
              <xsl:value-of select="."/>
            </dl>
            <dt>
              <xsl:value-of select="following-sibling::xhtml:p"/>
            </dt>
          </xsl:for-each>
        </dd>
        <h3>
          <xsl:value-of select="xhtml:h3"/>
        </h3>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>